<?php

class Result {
    const __default = self::Success;

    const Success = 0;
    const Fail = 1;
    const FailMail = 2;
    const FailLogin = 3;
    const FailLoginDup = 4;
    const FailLoginNoApprover = 5;
    const FailVerify = 6;
    const FailNotRegisted = 7;
    const FailTimeout = 8;
    const FailLicenseDate = 9;
    const FailLicenseCount = 10;
    const FailUploadCount = 11;
    const FailUploadSize = 12;
}

class AppParam
{
    var $_param;

    function __construct()
    {

    }

    /**
     * @param $key - Key
     * @param $value - Value
     */
    function Set($key, $value)
    {
        $result = "{" . $key . ":" . $value . ":" . $key . "}";
        $this->_param .= $result;
    }

    /**
     * @param $value - Value
     */
    function SetResult($value)
    {
        $this->Set("result", $value);
    }

    /**
     * @param $key
     * @param $value
     */
    function SetArray($key, $value)
    {
        $rows = count($value);
        $this->Set($key . "Rows", $rows);
        if ($rows > 0)
        {
            $col_array = null;
            foreach ($value as $k => $v)
            {
                $col_array = json_decode(json_encode($v), true);
                break;
            }

            $cols = count($col_array);
            $this->Set($key . "Cols", $cols);

            $col = 0;
            foreach ($col_array as $k => $v)
            {
                $this->Set($key . "Col" . $col, $k);
                $col++;
            }

            $row = 0;
            foreach ($value as $rk => $rv)
            {
                $col = 0;
                foreach ($rv as $ck => $cv)
                {
                    $this->Set($key . $row . "-" . $col, $cv);
                    $col++;
                }
                $row++;
            }
        }
    }

    function SetString($id)
    {
        $this->_param .= $id;
    }

    function Get()
    {
        return $this->_param;
    }
}