<?php

    /**
    * @param int $length = 10
    * @return string
    */

    function Encode( $string ) {
        $rand = CodeGenerate(5);
        $new = $rand.$string.$rand;
        $enc = base64_encode($new);
        $enc = str_replace("+", "_", $enc);
        $enc = str_replace("=", "-", $enc);
        return $enc;
    }
    function Decode( $string ) {
        $string = str_replace("_", "+", $string);
        $string = str_replace("-", "=", $string);
        $dec = base64_decode($string);
        $origin = substr($dec, 5, strlen($dec)- 10);
        return $origin;
    }

    function CodeGenerate($length = 10)
    {
        $characters = '0123456789abcdef';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    function FCRequestLinkCode($uuid, $accept, $lang_index, $w_export_mode)
    {
        $list = array(
            "uuid" => $uuid,
            "accept" => $accept,
            "lang_index" => $lang_index,
            "export_mode" => $w_export_mode,
        );

        $link = serialize($list);
        $encoded = Encode($link);

        return $encoded;
    }

    function FCRequestLinkDecode($ans, &$uuid, &$accept, &$lang_index, &$w_export_mode)
    {
        $decoded = Decode($ans);
        $list = unserialize($decoded);

        $uuid = $list["uuid"];
        $accept = $list["accept"];
        $lang_index = $list["lang_index"];
        $w_export_mode = $list["export_mode"];
    }

    function FCDownloadLinkCode($uuid, $lang_index)
    {
        $list = array(
            "uuid" => $uuid,
            "lang_index" => $lang_index,
        );

        $link = serialize($list);
        $encoded = Encode($link);

        return $encoded;
    }

    function FCDownloadLinkDecode($ans, &$uuid, &$lang_index)
    {
        $decoded = Decode($ans);
        $list = unserialize($decoded);

        $uuid = $list["uuid"];
        $lang_index = $list["lang_index"];
    }