<?php

require_once('db/db.php');
require_once('StringRes.php');
require_once ('Config.php');
require_once('log.php');

class FCStatus
{
    const StatusNone    = 0;
    const StatusApporveWait = 1;
    const StatusApproved = 2;
    const StatusDeny = 3;
    const StatusCancel = 4;
}

class UploadStatus
{
    const StatusUpload = 0;
    const StatusLimitCount = 1;
    const StatusLimitDate = 2;
}

class ExportMode
{
    const ExportModeACP     = 0;
    const ExportModePDF     = 1;
    const ExportModeSACP    = 2;
}

class LogAction
{
    const LogSecuPDFCountLimit = 70;
    const LogSecuPDFDateLimit = 71;
    const LogSecuPDFBlockViewerID = 72;
    const LogSecuPDFOpen = 73;
    const LogUploadDownload = 82;
    const LogUploadCountLimit = 83;
    const LogUploadDateLimit = 84;
}

const DEFAULT_LIMIT_COUNT = 5;
const DEFAULT_LIMIT_DAY = 3;

class DataCtrl
{
    var $db;
    function __construct()
    {
//        global $db;
//        if ( isset( $db) )
//            return;
        $this->db= new appdb( DB_USER, DB_PASSWORD, DB_NAME, DB_HOST );
    }

    function beginsWith( $str, $sub ) {
        return ( substr( $str, 0, strlen( $sub ) ) === $sub );
    }

    function endsWith( $str, $sub ) {
        return ( substr( $str, strlen( $str ) - strlen( $sub ) ) === $sub );
    }

    function GetNewId($table)
    {
        $id = 1;
        if ($table != null || $table != "") {
            $sql_buf = "SELECT MAX(Id) AS C FROM $table";
            $result = $this->db->get_results($sql_buf);
            foreach ($result as $rs) {
                if ($rs->C != null)
                    $id = $rs->C + 1;
            }
        }
        return $id;
    }

    function GetSetting($name)
    {
        $w_ini = parse_ini_file("setting.ini");
        $w_smtp_url = $w_ini['SMTP Server URL'];
        $w_smtp_id = $w_ini['Logon Name'];
        $w_smtp_password = $w_ini['Logon Password'];
        $w_smtp_port = $w_ini['SMTP Server Port'];
        $w_name = $w_ini['Name'];
        $w_mail_address = $w_ini['Mail Address'];
        $w_mail_security = $w_ini["SMTP Security"];
        $w_limit_day = $w_ini["Limit Day"];
        $w_limit_count = $w_ini["Limit Count"];
        $w_daily_max_count = $w_ini["Daily Max Count"];
        $w_daily_total_size = $w_ini["Daily Total Size"];

        if ($name == 'SmtpUrl')
        {
            if (!empty($w_smtp_url))
                return $w_smtp_url;
        }
        else if ($name == 'SmtpPassword')
        {
            if (!empty($w_smtp_password))
                return $w_smtp_password;
        }
        else if ($name == 'SmtpId')
        {
            if (!empty($w_smtp_id))
                return $w_smtp_id;
        }
        else if ($name == 'SmtpPort')
        {
            if (!empty($w_smtp_port))
                return $w_smtp_port;
        }
        else if ($name == 'AdminName')
        {
            if (!empty($w_name))
                return $w_name;
        }
        else if ($name == 'AdminEmail')
        {
            if (!empty($w_mail_address))
                return $w_mail_address;
        }
        else if ($name == 'SmtpSecurity')
        {
            if (!empty($w_mail_security))
                return $w_mail_security;
        }
        else if ($name == 'Limit Count')
        {
            if (!empty($w_limit_count))
                return $w_limit_count;
        }
        else if ($name == 'Limit Day')
        {
            if (!empty($w_limit_day))
                return $w_limit_day;
        }
        else if ($name == 'Daily Max Count')
        {
            if (!empty($w_daily_max_count))
                return $w_daily_max_count;
        }
        else if ($name == 'Daily Total Size')
        {
            if (!empty($w_daily_total_size))
                return $w_daily_total_size;
        }

        $sql_buf = "SELECT Value FROM table_setting WHERE Name = '%s'";
        $sql = $this->db->prepare($sql_buf, $name);
        $result = $this->db->get_results($sql);

        $value = null;
        foreach ($result as $rs) {
            $value = $rs->Value;
        }
        return $value;
    }

    function SetSetting($name, $value)
    {
        $sql_buf = "UPDATE table_setting SET Value = '$value' WHERE Name = '%s'";
        $sql = $this->db->prepare($sql_buf, $name);
        $result = $this->db->query($sql);
        if ($result === false)
            return false;
        return true;
    }

    function UpgradeDB()
    {
        $sql_buf = "SET FOREIGN_KEY_CHECKS=0;";
        $this->db->query($sql_buf);

        $sql_buf = "SHOW TABLES LIKE 'table_temp_pol'";
        $result = $this->db->get_results($sql_buf);
        if (empty($result))
        {
            $sql_buf = "CREATE TABLE `table_temp_pol` (".
                "`uuid` varchar(255) NOT NULL DEFAULT '',".
                "`status` varchar(255) NOT NULL DEFAULT '',".
                "`time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',".
                "PRIMARY KEY (`uuid`)".
                ") ENGINE=InnoDB DEFAULT CHARSET=utf8;";
            $this->db->query($sql_buf);
        }

        $sql_buf = "SHOW TABLES LIKE 'table_export'";
        $result = $this->db->get_results($sql_buf);
        if (empty($result))
        {
            $sql_buf = "CREATE TABLE `table_export` (".
                "`uuid` varchar(255) NOT NULL DEFAULT '',".
                "`status` varchar(255) NOT NULL DEFAULT '',".
                "`time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',".
                "PRIMARY KEY (`uuid`)".
                ") ENGINE=InnoDB DEFAULT CHARSET=utf8;";
            $this->db->query($sql_buf);
        }

        $sql_buf = "SHOW TABLES LIKE 'table_upload'";
        $result = $this->db->get_results($sql_buf);
        if (empty($result))
        {
            $sql_buf = "CREATE TABLE `table_upload` (".
                "`upload_uuid` varchar(255) NOT NULL DEFAULT '',".
                "`uuid` varchar(255) NOT NULL DEFAULT '',".
                "`status` smallint(6) NOT NULL DEFAULT '0',".
                "`time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',".
                "`limit_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',".
                "`limit_count` smallint(6) NOT NULL DEFAULT '3',".
                "`download_count` smallint(6) NOT NULL DEFAULT '0',".
                "`upload_file` varchar(255) NOT NULL DEFAULT '',".
                "`upload_file_size` bigint(20) NOT NULL DEFAULT '0',".
                "`export_file` varchar(255) NOT NULL DEFAULT '',".
                "`is_approved` smallint(6) NOT NULL DEFAULT '0',".
                "`original_file_size` bigint(20) NOT NULL DEFAULT '0',".
                "PRIMARY KEY (`upload_uuid`)".
                ") ENGINE=InnoDB DEFAULT CHARSET=utf8;";
            $this->db->query($sql_buf);
        }

        $sql_buf = "SHOW TABLES LIKE 'table_setting'";
        $result = $this->db->get_results($sql_buf);
        if (empty($result)) {
            $sql_buf = "CREATE TABLE `table_setting` (" .
                "`Id` bigint(20) NOT NULL," .
                "`Name` varchar(255) NOT NULL DEFAULT ''," .
                "`Value` varchar(255) NOT NULL DEFAULT ''," .
                "PRIMARY KEY (`Id`)" .
                ") ENGINE=InnoDB DEFAULT CHARSET=utf8";
            $result = $this->db->query($sql_buf);
            if ($result === false) {

            } else {
                $sql_buf = "INSERT INTO `table_setting` VALUES ('0', 'Version', '4')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('1', 'AdminName', '')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('2', 'AdminEmail', '')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('3', 'AdminPassword', '')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('4', 'AdminLang', '0')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('5', 'SmtpUrl', '')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('6', 'SmtpId', '')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('7', 'SmtpPassword', '')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('8', 'SmtpPort', '')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('9', 'SmtpSecurity', '')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('10', 'SmtpAuth', '1')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('11', 'Auto Reject', '1')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('12', 'Auto Reject Period', '1')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('13', 'Limit Day', '5')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('14', 'Limit Count', '3')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('15', 'Daily Max Count', '10')";
                $this->db->query($sql_buf);
                $sql_buf = "INSERT INTO `table_setting` VALUES ('16', 'Daily Total Size', '100')";
                $this->db->query($sql_buf);
            }
        }

        $sql_buf = "SHOW TABLES LIKE 'table_pdf'";
        $result = $this->db->get_results($sql_buf);
        if (empty($result))
        {
            $sql_buf = "CREATE TABLE `table_pdf` (".
                "`uuid` varchar(255) NOT NULL DEFAULT '',".
                "`pdf_uuid` varchar(255) NOT NULL DEFAULT '',".
                "`receiver_name` varchar(255) NOT NULL DEFAULT '',".
                "`receiver_mail` varchar(255) NOT NULL DEFAULT '',".
                "`company` varchar(255) NOT NULL DEFAULT '',".
                "`viewer_id` varchar(255) NOT NULL DEFAULT '',".
                "`limit_count` bigint(20) NOT NULL DEFAULT '0',".
                "`limit_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',".
                "`view_count` bigint(20) NOT NULL DEFAULT '0',".
                "`status` bigint(20) NOT NULL DEFAULT '0',".
                "`filename` varchar(255) NOT NULL DEFAULT '',".
                "PRIMARY KEY (`pdf_uuid`)".
                ") ENGINE=InnoDB DEFAULT CHARSET=utf8;";
            $this->db->query($sql_buf);
        }

        $sql_buf = "SHOW TABLES LIKE 'table_log'";
        $result = $this->db->get_results($sql_buf);
        if (empty($result)) {
            $sql_buf = "CREATE TABLE `table_log` (" .
                "`Id` bigint(20) unsigned NOT NULL AUTO_INCREMENT," .
                "`Time` bigint(20) unsigned NOT NULL DEFAULT '0'," .
                "`Action` smallint(6) NOT NULL DEFAULT '0'," .
                "`Column1` varchar(255) NOT NULL DEFAULT ''," .
                "`Column2` varchar(255) NOT NULL DEFAULT ''," .
                "`Column3` varchar(255) NOT NULL DEFAULT ''," .
                "`Column4` varchar(255) NOT NULL DEFAULT ''," .
                "`Column5` varchar(255) NOT NULL DEFAULT ''," .
                "`Column6` varchar(255) NOT NULL DEFAULT ''," .
                "`Column7` varchar(255) NOT NULL DEFAULT ''," .
                "`Column8` varchar(255) NOT NULL DEFAULT ''," .
                "`Column9` varchar(255) NOT NULL DEFAULT ''," .
                "`Column10` varchar(255) NOT NULL DEFAULT ''," .
                "`Column11` bigint(20) NOT NULL DEFAULT '0'," .
                "PRIMARY KEY (`Id`)" .
                ") ENGINE=InnoDB DEFAULT CHARSET=utf8";
            $this->db->query($sql_buf);
        }

        $curVersion = $this->GetSetting("Version");
        $this->UpgradeTable($curVersion);
    }

    function UpgradeTable($curVersion)
    {
        if ($curVersion == "1") {
            $sql_buf = "INSERT INTO `table_setting` VALUES ('11', 'Auto Reject', '1')";
            $this->db->query($sql_buf);
            $sql_buf = "INSERT INTO `table_setting` VALUES ('12', 'Auto Reject Period', '1')";
            $this->db->query($sql_buf);
            $sql_buf = "UPDATE `table_setting` SET Value='2' WHERE Name='Version'";
            $this->db->query($sql_buf);
        }

        if ($curVersion == "2") {
            $sql_buf = "INSERT INTO `table_setting` VALUES ('13', 'Limit Day', '5')";
            $this->db->query($sql_buf);
            $sql_buf = "INSERT INTO `table_setting` VALUES ('14', 'Limit Count', '3')";
            $this->db->query($sql_buf);
            $sql_buf = "UPDATE `table_setting` SET Value='3' WHERE Name='Version'";
            $this->db->query($sql_buf);
        }

        if ($curVersion == "3") {
            $sql_buf = "alter table `table_upload` MODIFY status smallint(6) NOT NULL DEFAULT '0'";
            $this->db->query($sql_buf);
            $sql_buf = "alter table `table_upload` MODIFY limit_count smallint(6) NOT NULL DEFAULT '0'";
            $this->db->query($sql_buf);
            $sql_buf = "alter table `table_upload` MODIFY download_count smallint(6) NOT NULL DEFAULT '0'";
            $this->db->query($sql_buf);
            $sql_buf = "alter table `table_upload` MODIFY upload_file_size bigint(20) NOT NULL DEFAULT '0'";
            $this->db->query($sql_buf);
            $sql_buf = "ALTER TABLE `table_upload` ADD is_approved smallint(6) NOT NULL DEFAULT '0';";
            $this->db->query($sql_buf);
            $sql_buf = "ALTER TABLE `table_upload` ADD original_file_size bigint(20) NOT NULL DEFAULT '0';";
            $this->db->query($sql_buf);
            $sql_buf = "INSERT INTO `table_setting` VALUES ('15', 'Daily Max Count', '10')";
            $this->db->query($sql_buf);
            $sql_buf = "INSERT INTO `table_setting` VALUES ('16', 'Daily Total Size', '100')";
            $this->db->query($sql_buf);
            $sql_buf = "UPDATE `table_setting` SET Value='4' WHERE Name='Version'";
            $this->db->query($sql_buf);
        }
    }

    function AddPolicyStatus($uuid, $status)
    {
        $sql_buf = "SELECT uuid FROM table_temp_pol where uuid = '%s'";
        $sql = $this->db->prepare($sql_buf, $uuid);

        $dt = new DateTime('NOW');

        $result = $this->db->get_results($sql);
        if (empty($result))
        {
            $sql_buf = "INSERT INTO table_temp_pol (uuid, status, `time`) VALUES ('%s', %d, '%s')";
            $sql = $this->db->prepare($sql_buf, $uuid, $status, $dt->format("Y-m-d H:i:s"));

            $result = $this->db->get_results($sql);
        }
        else
        {
            $sql_buf = "UPDATE table_temp_pol SET status=%d , `time`='%s' where uuid='%s'";
            $sql = $this->db->prepare($sql_buf, $status, $dt->format("Y-m-d H:i:s") , $uuid);

            $result = $this->db->get_results($sql);
        }
        return $result;
    }

    function GetPolicyStatus($uuid)
    {
        $sql_buf = "SELECT status FROM table_temp_pol where uuid= '%s'";
        $sql = $this->db->prepare($sql_buf, $uuid);

        $result = $this->db->get_results($sql);
        $retVal = 0;
        foreach ($result as $value)
        {
            $retVal = $value->status;
        }

        return $retVal;
    }

    function SetPolicyStatus($uuid, $status)
    {
        $sql_buf = "UPDATE table_temp_pol SET status=%d where uuid='%s'";
        $sql = $this->db->prepare($sql_buf, $status, $uuid);

        $result = $this->db->query($sql);
        if ($result === 0 || $result === false)
            return false;
        return true;
    }

    function RejectPolicyStatus($reject_period) //  period = day
    {
        $cur_time = new DateTime("NOW");
        $key_time = $cur_time->sub(new DateInterval("P" . $reject_period . "D"));
        $key_time_str = $key_time->format("Y-m-d H:i:s");

        $sql_buf = "Delete from table_temp_pol where status=%d and `time` < '%s'";
        $sql = $this->db->prepare($sql_buf, FCStatus::StatusApporveWait, $key_time_str);

        $result = $this->db->query($sql);
        if ($result === 0 || $result === false)
            return false;
        return true;
    }

    function AddExportStatus($uuid, $status)
    {
        $sql_buf = "SELECT uuid FROM table_export where uuid = '%s'";
        $sql = $this->db->prepare($sql_buf, $uuid);

        $dt = new DateTime('NOW');

        $result = $this->db->get_results($sql);
        if (empty($result))
        {
            $sql_buf = "INSERT INTO table_export (uuid, status, `time`) VALUES ('%s', %d, '%s')";
            $sql = $this->db->prepare($sql_buf, $uuid, $status, $dt->format("Y-m-d H:i:s"));

            $result = $this->db->get_results($sql);
        }
        else
        {
            $sql_buf = "UPDATE table_export SET status=%d , `time`='%s' where uuid='%s'";
            $sql = $this->db->prepare($sql_buf, $status, $dt->format("Y-m-d H:i:s") , $uuid);

            $result = $this->db->get_results($sql);
        }
        return $result;
    }
    
    function AddUpload($upload_uuid, $uuid, $status, $upload_file, $upload_file_size, $export_file, $is_approved, $original_file_size)
    {
        $sql_buf = "SELECT upload_uuid FROM table_upload where upload_uuid = '%s'";
        $sql = $this->db->prepare($sql_buf, $upload_uuid);

        $limit_count = $this->GetSetting("Limit Count");
        $limit_day = $this->GetSetting("Limit Day");
        $cur_time = new DateTime('NOW');
        $limit_date = new DateTime('NOW');
        $limit_date->add(new DateInterval("P" . $limit_day . "D"));

        $result = $this->db->get_results($sql);
        if (empty($result))
        {
            $sql_buf = "INSERT INTO table_upload (`upload_uuid`, `uuid`, `status`, `time`, `limit_time`, `limit_count`, `download_count`, `upload_file`, `upload_file_size`, `export_file`, `is_approved`, `original_file_size`) VALUES ('%s', '%s', %d, '%s', '%s', %d, %d, '%s', %d, '%s', %d, %d)";
            $sql = $this->db->prepare($sql_buf, $upload_uuid, $uuid, $status, $cur_time->format("Y-m-d H:i:s"), $limit_date->format("Y-m-d H:i:s"), $limit_count, 0, $upload_file, $upload_file_size, $export_file, $is_approved, $original_file_size);

            $result = $this->db->get_results($sql);
        }
        else
        {
            $sql_buf = "UPDATE table_upload SET `uuid` = '%s', `status` = %d , `time` = '%s', `limit_time` = '%s', `limit_count` = %d, `download_count` = %d, `upload_file` = '%s', `upload_file_size` = %d, `export_file` = '%s', `is_approved` = %d , `original_file_size` = %d where `upload_uuid`='%s'";
            $sql = $this->db->prepare($sql_buf, $uuid, $status, $cur_time->format("Y-m-d H:i:s"), $limit_date->format("Y-m-d H:i:s"), $limit_count, 0, $upload_file, $upload_file_size, $export_file, $is_approved, $original_file_size, $upload_uuid);

            $result = $this->db->get_results($sql);
        }
        if ($result === 0 || $result === false)
            return false;
        return true;
    }

    function GetUpload($upload_uuid)
    {
        $sql_buf = "SELECT * FROM table_upload where upload_uuid= '%s'";
        $sql = $this->db->prepare($sql_buf, $upload_uuid);

        $result = $this->db->get_results($sql);

        return $result;
    }

    function GetAllUpload()
    {
        $sql_buf = "SELECT * FROM table_upload";

        $result = $this->db->get_results($sql_buf);

        return $result;
    }

    function GetUploadCount($uuid)
    {
        $sql_buf = "SELECT COALESCE(COUNT(*), 0) AS upload_count FROM table_upload WHERE `uuid`= '%s' AND `time`>='%s' AND `time`<='%s' AND `is_approved`=0";
        $sql = $this->db->prepare($sql_buf, $uuid, date("Y-m-d 00:00:00"), date("Y-m-d 23:59:59"));

        $result = $this->db->get_results($sql);

        $count = 0;
        foreach ($result as $rs) {
            $count = $rs->upload_count;
        }

        return $count;
    }

    function GetUploadSize($uuid)
    {
        $sql_buf = "SELECT COALESCE(SUM(original_file_size), 0) AS upload_size FROM table_upload WHERE `uuid`= '%s' AND `time`>='%s' AND `time`<='%s' AND `is_approved`=0";
        $sql = $this->db->prepare($sql_buf, $uuid, date("Y-m-d 00:00:00"), date("Y-m-d 23:59:59"));

        $result = $this->db->get_results($sql);

        $size = 0;
        foreach ($result as $rs) {
            $size = $rs->upload_size;
        }

        return $size;
    }

    function SetDownloadCount($upload_uuid, $count)
    {
        $sql_buf = "UPDATE table_upload SET download_count=%d where upload_uuid='%s'";
        $sql = $this->db->prepare($sql_buf, $count, $upload_uuid);

        $result = $this->db->query($sql);
        if ($result === 0 || $result === false)
            return false;
        return true;
    }

    function SetUploadStatus($upload_uuid, $status)
    {
        $sql_buf = "UPDATE table_upload SET status=%d where upload_uuid='%s'";
        $sql = $this->db->prepare($sql_buf, $status, $upload_uuid);

        $result = $this->db->query($sql);
        if ($result === 0 || $result === false)
            return false;
        return true;
    }

    function GetExportStatus($uuid)
    {
        $sql_buf = "SELECT status FROM table_export where uuid= '%s'";
        $sql = $this->db->prepare($sql_buf, $uuid);

        $result = $this->db->get_results($sql);
        $retVal = 0;
        foreach ($result as $value)
        {
            $retVal = $value->status;
        }

        return $retVal;
    }

    function SetExportStatus($uuid, $status)
    {
        $sql_buf = "UPDATE table_export SET status=%d where uuid='%s'";
        $sql = $this->db->prepare($sql_buf, $status, $uuid);

        $result = $this->db->query($sql);
        if ($result === 0 || $result === false)
            return false;
        return true;
    }

    function RejectExportStatus($reject_period) //  period = day
    {
        $cur_time = new DateTime("NOW");
        $key_time = $cur_time->sub(new DateInterval("P" . $reject_period . "D"));
        $key_time_str = $key_time->format("Y-m-d H:i:s");

        $sql_buf = "Delete from table_export where status=%d and `time` < '%s'";
        $sql = $this->db->prepare($sql_buf, FCStatus::StatusApporveWait, $key_time_str);

        $result = $this->db->query($sql);
        if ($result === 0 || $result === false)
            return false;
        return true;
    }

    function SecurePDFFilesADD($export_id, $pdf_uuids, $receiver_name, $receiver_mail, $company, $viewer_id, $limit_count, $limit_date, $paths)
    {
        $arr_pdf = explode(";", $pdf_uuids);
        $arr_path = explode("\\n", $paths);

        for ($i = 0; $i < count($arr_pdf); $i++) {
            $real_path = explode("|", $arr_path[$i]);
            $sql_buf = "INSERT INTO table_pdf (uuid, pdf_uuid, receiver_name, receiver_mail, company, viewer_id, limit_count, limit_date, filename) VALUES  ('%s', '%s', '%s', '%s', '%s', '%s', %d, '%s', '%s')";
            $sql = $this->db->prepare($sql_buf, $export_id, $arr_pdf[$i], $receiver_name, $receiver_mail, $company, $viewer_id, $limit_count, $limit_date, $real_path[0]);
            $this->db->query($sql);
        }
    }

    function SetSecuPDFStatus($id, $status)
    {
        $sql_buf = "UPDATE table_pdf SET status='$status' WHERE uuid='$id'";
        $result = $this->db->query($sql_buf);
        if ($result === false)
            return false;
        return true;
    }

    function GetApprovedSecuPDF($doc_id)
    {
        $sql_buf = "SELECT * from table_pdf WHERE pdf_uuid='$doc_id'";

        $result = $this->db->get_results($sql_buf);

        return $result;
    }

    function GetLog()
    {
        $sql_buf = "SELECT * FROM table_log";
        $result = $this->db->get_results($sql_buf);
        return $result;
    }

    function DeleteLog()
    {
        $sql_buf = "DELETE FROM table_log";
        $result = $this->db->query($sql_buf);
        if ($result === false)
            return false;
        return true;
    }

    function SetSecuPDFViewCount($id, $count)
    {
        $sql_buf = "UPDATE table_pdf SET view_count='$count' WHERE pdf_uuid='$id'";
        $result = $this->db->query($sql_buf);
        if ($result === false)
            return false;
        return true;
    }

    function AddSecuPDFLog($action, $viewid, $filename, $receiver_name, $receiver_mail, $globalip, $pcname, $filesize)
    {
        $id = $this->GetNewId("table_log");
        $sql_buf = "INSERT INTO table_log (Time, Action, Id, Column1, Column2, Column3, Column4, Column5, Column6, Column7) " .
            "VALUES (%d, %d, %d, '%s', '%s', '%s', '%s', '%s', '%s', %d)";
        $sql = $this->db->prepare($sql_buf, time(), $action, $id, $filename, $receiver_name, $receiver_mail, $viewid, $globalip, $pcname, $filesize);
        $result = $this->db->query($sql);
        if ($result === false)
            return false;
        return true;
    }

    function AddUploadLog($action, $filename, $filesize, $msg, $ip)
    {
        $id = $this->GetNewId("table_log");
        $sql_buf = "INSERT INTO table_log (Time, Action, Column1, Column2, Column3, Column4) " .
            "VALUES (%d, %d, '%s', %d, '%s', '%s')";
        $sql = $this->db->prepare($sql_buf, time(), $action, $filename, $filesize, $msg, $ip);
        $result = $this->db->query($sql);
        if ($result === false)
            return false;
        return true;
    }

    function GetMultiMessage($multi_message)
    {
        $w_multi_message = $multi_message;
        $sql_buf = "SELECT * FROM table_mail";
        $result = $this->db->get_results($sql_buf);

        foreach ($result as $value)
        {

            $id = $value->Id;
            $lang = $value->Lang;
            $type = $value->Type;
            $content = $value->Content;

            if(!isset($w_multi_message[$id]))
                continue;

            $w_value_key = "value";
            $w_title_key = "title";
            if ($lang == 1) {
                $w_value_key .= "_en";
                $w_title_key .= "_en";
            }
            else if ($lang == 2) {
                $w_value_key .= "_jp";
                $w_title_key .= "_jp";
            }

            if ($type == 0) // title
            {
                $w_multi_message[$id][$w_title_key] = $content;
            }
            else            // value
            {
                $w_multi_message[$id][$w_value_key] = $content;
            }
        }

        return $w_multi_message;
    }
}