<?php
    require_once("MailSend.php");
    require_once("DataCtrl.php");

    $g_a_ref = array("%linkAccept%", "%linkDeny%", "%cancelLink%");

    function GetDisplayName($name, $mail)
    {
        $display = $mail;
        if ($name != null && $name != "")
        {
            $display = $name . "<" . $mail . ">";
        }
        return $display;
    }

    function ChangeMailContent($w_id, $w_title, $w_val, $w_lang)
    {
        global $g_multi_message;

        $w_value_key = "value";
        $w_title_key = "title";
        if ($w_lang == 1) {
            $w_value_key .= "_en";
            $w_title_key .= "_en";
        }
        else if ($w_lang == 2) {
            $w_value_key .= "_jp";
            $w_title_key .= "_jp";
        }

        $g_multi_message[$w_id][$w_value_key] = $w_val;
        $g_multi_message[$w_id][$w_title_key] = $w_title;

        return true;
    }

    function GetUploadPath($path)
    {
        $w_data_ctrl = new DataCtrl();
        $basePath = $w_data_ctrl->GetSetting("UploadPath");

        if ($basePath == "")
            $upload_path = "./Upload/" . $path;
        else
            $upload_path = $basePath."/./Upload/" . $path;

        $upload_path = str_replace("\\", "/", $upload_path);
        $upload_path = str_replace("//", "/", $upload_path);

        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            // $upload_path = iconv("UTF-8", "cp949", $upload_path);
            $upload_path = str_replace("/", "\\", $upload_path);
        }

        return $upload_path;
    }

    function GetBackupPath($path)
    {
        $w_data_ctrl = new DataCtrl();
        $basePath = $w_data_ctrl->GetSetting("BackupPath");

        if ($basePath == "")
            $upload_path = "./Backup/" . $path;
        else
            $upload_path = $basePath."/./Backup/" . $path;

        $upload_path = str_replace("\\", "/", $upload_path);
        $upload_path = str_replace("//", "/", $upload_path);

        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            // $upload_path = iconv("UTF-8", "cp949", $upload_path);
            $upload_path = str_replace("/", "\\", $upload_path);
        }

        return $upload_path;
    }

    function ReplaceHyperLinkHtml($w_value)
    {
        $w_retVal = $w_value;

        $pattern = "!&lt;a href=(.*?)&lt;\/a&gt;!is";
        $bMatch = preg_match_all($pattern, $w_retVal, $matches);
        if ($bMatch)
        {
            foreach ($matches[0] as $match)
            {
                $w_retVal = preg_replace($pattern,html_entity_decode($match),$w_retVal, 1);
            }
        }

        return $w_retVal;
    }

    function GetTitle($id, $dic, $lang)
    {
        global $g_multi_message;

        $w_title_key = "title";
        if ($lang == 1) {
            $w_title_key .= "_en";
        }
        else if ($lang == 2) {
            $w_title_key .= "_jp";
        }

        $w_title = $g_multi_message[$id][$w_title_key];

        $w_ini = parse_ini_file("setting.ini", true);
        $w_title_ini = $w_ini[$id][$w_title_key];
        if (!empty($w_title_ini))
            $w_title = $w_title_ini;

        foreach ($dic as $dic_key => $dic_val)
        {
            $w_title = ReplaceKeyword("%$dic_key%", $dic_val, $w_title);
        }

        $w_title = str_replace("&", "&amp;", $w_title);
        $w_title = str_replace("<", "&lt;", $w_title);
        $w_title = str_replace(">", "&gt;", $w_title);
        $w_title = str_replace("\\n", "<br>", $w_title);
        $w_title = str_replace("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;", $w_title);
        $w_title = str_replace("\'", "&apos;", $w_title);
        $w_title = str_replace("\"", "&quot;", $w_title);

        $w_title = ReplaceHyperLinkHtml($w_title);


        return $w_title;
    }



    function GetBody($id, $dic, $lang)
    {
        global $g_multi_message;

        $w_default_key = "default";
        if ($lang == 1) {
            $w_default_key .= "_en";
        }
        else if ($lang == 2) {
            $w_default_key .= "_jp";
        }

        $w_value = $g_multi_message[$id][$w_default_key];

        $w_ini = parse_ini_file("setting.ini", true);
        $w_value_ini = $w_ini[$id][$w_default_key];
        if (!empty($w_value_ini))
            $w_value = $w_value_ini;

        foreach ($dic as $dic_key => $dic_val)
        {
            $w_value = ReplaceKeyword("%$dic_key%", $dic_val, $w_value);
        }

        $w_value = str_replace("&", "&amp;", $w_value);
        $w_value = str_replace("<", "&lt;", $w_value);
        $w_value = str_replace(">", "&gt;", $w_value);
        $w_value = str_replace("\\n", "<br>", $w_value);
        $w_value = str_replace("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;", $w_value);
        $w_value = str_replace("\'", "&apos;", $w_value);
        $w_value = str_replace("\"", "&quot;", $w_value);

        $w_value = ReplaceHyperLinkHtml($w_value);
        return $w_value;
    }

    function GetString($key, $w_lang)
    {
        if ($w_lang == 1)
        {
            global $g_message_en;
            $string = $g_message_en[$key];
            return $string;
        }

        else if ($w_lang ==  2)
        {
            global $g_message_jp;
            $string = $g_message_jp[$key];
            return $string;
        }
        else
        {
            global $g_message;
            $string = $g_message[$key];
            return $string;
        }

    }

    function GetFilePaths($path)
    {
        $w_path = $path;
        return $w_path;
    }

    function GetFileNames($path)
    {
        $w_path = $path;
        return $w_path;
    }

    function GetSize($size)
    {
        $w_size = $size;
        return $w_size;
    }

    function ReplaceKeyword($search_string, $replace_string, $origin_string)
    {
        global $g_a_ref;

        $new_string = $origin_string;
        $find = false;

        foreach ($g_a_ref as $item)
        {
            if ($search_string === $item)
                $find = true;
        }

//        $replace_string = str_replace(" ", "&nbsp", $replace_string);

//        if ($find == true)
//        {
//            $new_string = str_replace($search_string, "<a href=\"" . $replace_string . "\">" . $replace_string . "</a>", $new_string);
//        }
//        else
//        {
            $new_string = str_replace($search_string, $replace_string, $new_string);
//        }

        return $new_string;
    }

    function GetBaseName($path) {
        $pattern = (strncasecmp(PHP_OS, 'WIN', 3) ? '/([^\/]+)[\/]*$/' : '/([^\/\\\\]+)[\/\\\\]*$/');
        if (preg_match($pattern, $path, $matches))
            return $matches[1];

        return '';
    }

    function GetDomain($email)
    {
        $domain_name = substr(strrchr($email, "@"), 1);
        return $domain_name;
    }

    function GetExportModeStr($export_mode, $lang)
    {
        $export_str = "";
        if ($export_mode == ExportMode::ExportModeACP)
            $export_str = GetString("StrExportModeACP", $lang);
        else if ($export_mode == ExportMode::ExportModePDF)
            $export_str = GetString("StrExportModePDF", $lang);
        else
            $export_str = GetString("StrExportModeSACP", $lang);

        return $export_str;
    }