<?php

require_once("mail/PHPMailerAutoload.php");
require_once("AppParam.php");
require_once("DataCtrl.php");

$g_message = array(
	"StrPageExportAcceptSuccess" => "파일 반출이 승인되었습니다.",
	"StrPageExportDeny" => "파일 반출이 취소되었습니다.",
	"StrPageUserAlreadProcessed" => "이미 처리된 건입니다.",
    "StrPageUserAlreadCanceled" => "신청자가 신청을 취소하였습니다.",
    "StrPageFCPolicyApproved" => "정책 일시 변경이 승인되었습니다.",
    "StrPageFCPolicyDeny" => "정책 일시 변경이 취소되었습니다.",
    "StrExportModeACP" => "원본 반출",
    "StrExportModePDF" => "보안PDF",
    "StrExportModeSACP" => "암호화 반출",
    "StrPageExportDenyDate" => "파일 반출 허용 기한이 지났습니다.",
    "StrPageExportDenyCount" => "파일 반출 허용 횟수가 초과되었습니다.",
    "StrInvalidRequest" => "무효한 요청입니다.",
);

$g_message_jp = array(
    "StrPageExportAcceptSuccess" => "ファイルエクスポート承認されました。",
    "StrPageExportDeny" => "ファイルエクスポートが取り消されました。",
    "StrPageUserAlreadProcessed" => "すでに処理された件です。",
    "StrPageUserAlreadCanceled" => "申請者が申請をキャンセルしました。",
    "StrPageFCPolicyApproved" => "ポリシー一時変更が承認されました。",
    "StrPageFCPolicyDeny" => "ポリシー一時変更が取り消されました。",
    "StrExportModeACP" => "原本エクスポート",
    "StrExportModePDF" => "セキュリティPDF",
    "StrExportModeSACP" => "暗号化エクスポート",
    "StrPageExportDenyDate" => "ファイルエクスポート許可期限が過ぎました。",
    "StrPageExportDenyCount" => "ファイルエクスポート許可の回数が超過しました。",
    "StrInvalidRequest" => "無効な要請です。",
);

$g_message_en = array(
    "StrPageExportAcceptSuccess" => "File has been approved.",
    "StrPageExportDeny" => "File export has been canceled.",
    "StrPageUserAlreadProcessed" => "It has already been processed.",
    "StrPageUserAlreadCanceled" => "It has already been canceled.",
    "StrPageFCPolicyApproved" => "Temporary policy change has been approved.",
    "StrPageFCPolicyDeny" => "Temporary policy change canceled.",
    "StrExportModeACP" => "ACP",
    "StrExportModePDF" => "Security PDF",
    "StrExportModeSACP" => "SACP",
    "StrPageExportDenyDate" => "File export has expired.",
    "StrPageExportDenyCount" => "File export count allowed to be exceeded.",
    "StrInvalidRequest" => "Invalid request.",
);

$g_multi_message = array(
    "StrMailAdminMail" => array(
                                        "id"=>"StrMailAdminMail",
                                    	"name"=>"관리자 메일 설정",
        								"title"=>"SECUDRIVE File Centralization SMTP 메일 서버 검사",
                                        "default_title"=>"SECUDRIVE File Centralization SMTP 메일 서버 검사",
										"vars"=>"송신자 명,name|송신자 메일 주소,email",
										"value"=>"",
										"default"=>"SECUDRIVE File Centralization SMTP 서버 검사 메일입니다.",
										"name_en"=>"Administrative Mail Setting",
										"title_en"=>"SECUDRIVE File Centralization Administrative Mail Setting",
                                        "default_title_en"=>"SECUDRIVE File Centralization Administrative Mail Setting",
										"vars_en"=>"Sender Name,name|Mail Address,email",
										"value_en"=>"",
										"default_en"=>"%name% <%email%> has been successfully set as SECUDRIVE File Centralization administrative mail.",
										"name_jp"=>"管理者のメール設定",
										"title_jp"=>"SECUDRIVE File Centralization 管理者のメール設定",
                                        "default_title_jp"=>"SECUDRIVE File Centralization 管理者のメール設定",
										"vars_jp"=>"送信者名,name|送信者名メールアドレス,email",
										"value_jp"=>"",
										"default_jp"=>"%name% <%email%>をSECUDRIVE File Sender管理者のメールアドレスに設定しました。",
                                ),
    "StrMailFCRequest" => array(
                                        "id"=>"StrMailFCRequest",
                                        "name"=>"SDFC 정책 일시 변경 요청",
                                        "title"=>"SECUDRIVE File Centralization 정책 일시 변경 신청",
                                        "default_title"=>"SECUDRIVE File Centralization 정책 일시 변경 신청",
                                        "vars"=>"신청자,userName|호스트 이름, hostName|신청 시간,requestTime|정책 내용 변경,content|정책 변경 기한,period|정책 변경 사유,reason|승인 링크,linkAccept|거부 링크,linkDeny",
                                        "value"=>"",
                                        "default"=>"%userName%(%hostName%) 님이 SECUDRIVE File Centralization 정책 일시 변경을 신청하였습니다.\\n\\n신청 시간:\\n%requestTime%\\n\\n정책 변경 내용:\\n%content%\\n\\n정책 변경 기한\\n%period%\\n\\n정책 변경 사유:\\n%reason%\\n\\n이 신청을 승인하려면 아래의 링크를 클릭하십시오:\\n<a href='%linkAccept%'>정책 변경 승인</a>\\n\\n이 신청을 거부하려면 아래의 링크를 클릭하십시오:\\n<a href=\"%linkDeny%\">정책 변경 거부</a>",
                                        "name_en"=>"SDFC Temporary Policy Change Request",
                                        "title_en"=>"SECUDRIVE File Centralization Temporary Policy Change Request",
                                        "default_title_en"=>"SECUDRIVE File Centralization Temporary Policy Change Request",
                                        "vars_en"=>"UserName,userName|HostName, hostName|RequestTime,requestTime|Content,content|Period,period|Reason,reason|AcceptLink,linkAccept|DenyLink,linkDeny",
                                        "value_en"=>"",
                                        "default_en"=>"The %userName%(%hostName%) has requested the SECUDRIVE File Centralization Temporary Policy Change.\\n\\nTime:\\n%requestTime%\\n\\nContent:\\n%content%\\n\\nPeriod:\\n%period%\\n\\nReason:\\n%reason%\\n\\nTo approve this request, click the following link.\\n<a href=\"%linkAccept%\">Approve</a>\\n\\nTo deny this request, click the following link.\\n<a href=\"%linkDeny%\">Deny</a>",
                                        "name_jp"=>"ポリシーの一時変更申請",
                                        "title_jp"=>"SECUDRIVE File Centralization ポリシーの一時変更申請",
                                        "default_title_jp"=>"SECUDRIVE File Centralization ポリシーの一時変更申請",
                                        "vars_jp"=>"申請者,userName|ホストネーム, hostName|申請時間,requestTime|変更内容,content|ポリシー変更期間,period|ポリシー変更の事由,reason|承認リンク,linkAccept|拒否リンク,linkDeny",
                                        "value_jp"=>"",
                                        "default_jp"=>"%userName%(%hostName%)さんがSECUDRIVE File Centralizationポリシー変更を申請しました。\\n\\n申請時間:\\n%requestTime%\\n\\n変更内容:\\n%content%\\n\\nポリシー変更期限:\\n%period%\\n\\nポリシー変更理由:\\n%reason%\\n\\n上記のエクスポートを承認するには、下記のリンクをクリックしてください:\\n<a href=\"%linkAccept%\">承認</a>\\n\\n上記のエクスポートを拒否するには、下記のリンクをクリックしてください:\\n<a href=\"%linkDeny%\">拒否</a>",
                                ),
    "StrMailExportRequest" => array(
                                        "id"=>"StrMailExportRequest",
                                        "name"=>"SDFC 반출 요청",
                                        "title"=>"SECUDRIVE File Centralization 반출 신청",
                                        "default_title"=>"SECUDRIVE File Centralization 반출 신청",
                                        "vars"=>"신청자,userName|호스트 이름, hostName|신청 시간,requestTime|반출 내용,content|파일 반출 모드,exportMode|반출 사유,reason|승인 링크,linkAccept|거부 링크,linkDeny",
                                        "value"=>"",
                                        "default"=>"%userName%(%hostName%) 님이 SECUDRIVE File Centralization 파일 반출을 신청하였습니다.\\n\\n신청 시간:\\n%requestTime%\\n\\n반출 내용:\\n%content%\\n\\n파일 반출 모드:\\n%exportMode%\\n\\n반출 사유:\\n%reason%\\n\\n이 신청을 승인하려면 아래의 링크를 클릭하십시오:\\n<a href='%linkAccept%'>반출 승인</a>\\n\\n이 신청을 거부하려면 아래의 링크를 클릭하십시오:\\n<a href=\"%linkDeny%\">반출 거부</a>",
                                        "name_en"=>"SDFC Export Request",
                                        "title_en"=>"SECUDRIVE File Centralization Export Request",
                                        "default_title_en"=>"SECUDRIVE File Centralization Export Request",
                                        "vars_en"=>"UserName,userName|HostName, hostName|RequestTime,requestTime|Content,content|ExportMode,exportMode|Reason,reason|AcceptLink,linkAccept|DenyLink,linkDeny",
                                        "value_en"=>"",
                                        "default_en"=>"The %userName%(%hostName%) has requested the SECUDRIVE File Centralization file export.\\n\\nTime:\\n%requestTime%\\n\\nContent:\\n%content%\\n\\nExport Mode:\\n%exportMode%\\n\\nReason:\\n%reason%\\n\\nTo approve this request, click the following link.\\n<a href=\"%linkAccept%\">Approve</a>\\n\\nTo deny this request, click the following link.\\n<a href=\"%linkDeny%\">Deny</a>",
                                        "name_jp"=>"ファイルエクスポートの申請",
                                        "title_jp"=>"SECUDRIVE File Centralization ファイルエクスポートの申請",
                                        "default_title_jp"=>"SECUDRIVE File Centralization ファイルエクスポートの申請",
                                        "vars_jp"=>"申請者,userName|ホストネーム, hostName|申請時間,requestTime|エクスポート内容,content|ファイルエクスポートモード,exportMode|エクスポート事由,reason|承認リンク,linkAccept|拒否リンク,linkDeny",
                                        "value_jp"=>"",
                                        "default_jp"=>"%userName%(%hostName%)さんがSECUDRIVE File Centralizationファイルのエクスポートを申請しました。\\n\\n申請時間:\\n%requestTime%\\n\\nエクスポート内容:\\n%content%\\n\\nファイルエクスポートモード:\\n%exportMode%\\n\\nエクスポート事由:\\n%reason%\\n\\n上記のエクスポートを承認するには、下記のリンクをクリックしてください:\\n<a href=\"%linkAccept%\">承認</a>\\n\\n上記のエクスポートを拒否するには、下記のリンクをクリックしてください:\\n<a href=\"%linkDeny%\">拒否</a>",
                                ),

    "StrMailExportPDFRequest" => array(
                                        "id"=>"StrMailExportPDFRequest",
                                        "name"=>"SDFC 반출 요청",
                                        "title"=>"SECUDRIVE File Centralization 반출 신청",
                                        "default_title"=>"SECUDRIVE File Centralization 반출 신청",
                                        "vars"=>"신청자,userName|호스트 이름, hostName|신청 시간,requestTime|반출 내용,content|파일 반출 모드,exportMode|반출 사유,reason|승인 링크,linkAccept|거부 링크,linkDeny|수신자 이름,receiverName|수신자 메일,receiverMail|회사,company|열람 기한,limitPeriod|열람 횟수,limitCount|수신자 뷰어ID,receiverID",
                                        "value"=>"",
                                        "default"=>"%userName%(%hostName%) 님이 SECUDRIVE File Centralization 파일 반출을 신청하였습니다.\\n\\n신청 시간:\\n%requestTime%\\n\\n반출 내용:\\n%content%\\n\\n파일 반출 모드:\\n%exportMode%\\n\\n수신자 정보:\\n이름:%receiverName%\\n이메일:%receiverMail%\\n회사:%company%\\n열람 기한:%limitPeriod%까지\\n열람 횟수:%limitCount%회 (0이면 제한 없음)\\n수신자 뷰어ID:%receiverID%\\n\\n반출 사유:\\n%reason%\\n\\n이 신청을 승인하려면 아래의 링크를 클릭하십시오:\\n<a href='%linkAccept%'>반출 승인</a>\\n\\n이 신청을 거부하려면 아래의 링크를 클릭하십시오:\\n<a href=\"%linkDeny%\">반출 거부</a>",
                                        "name_en"=>"SDFC Export Request",
                                        "title_en"=>"SECUDRIVE File Centralization Export Request",
                                        "default_title_en"=>"SECUDRIVE File Centralization Export Request",
                                        "vars_en"=>"UserName,userName|HostName, hostName|RequestTime,requestTime|Content,content|ExportMode,exportMode|Reason,reason|AcceptLink,linkAccept|DenyLink,linkDeny|ReceiverName,receiverName|ReceiverMail,receiverMail|Company,company|LimitPeriod,limitPeriod|LimitCount,limitCount|ReceiverViewerID,receiverID",
                                        "value_en"=>"",
                                        "default_en"=>"The %userName%(%hostName%) has requested the SECUDRIVE File Centralization file export.\\n\\nTime:\\n%requestTime%\\n\\nContent:\\n%content%\\n\\nExport Mode:\\n%exportMode%\\n\\nReceiver Information:\\nName:%receiverName%\\nMail Address:%receiverMail%\\nCompany:%company%\\nView Period:%limitPeriod%까지\\nView Count:%limitCount%회 (0 is unlimited)\\nReceiver Viewer ID:%receiverID%\\n\\nReason:\\n%reason%\\n\\nTo approve this request, click the following link.\\n<a href=\"%linkAccept%\">Approve</a>\\n\\nTo deny this request, click the following link.\\n<a href=\"%linkDeny%\">Deny</a>",
                                        "name_jp"=>"ファイルエクスポートの申請",
                                        "title_jp"=>"SECUDRIVE File Centralization ファイルエクスポートの申請",
                                        "default_title_jp"=>"SECUDRIVE File Centralization ファイルエクスポートの申請",
                                        "vars_jp"=>"申請者,userName|ホストネーム, hostName|申請時間,requestTime|エクスポート内容,content|エクスポート事由,reason|承認リンク,linkAccept|拒否リンク,linkDeny|受信者の名前,receiverName|受信者のメール,receiverMail|会社,company|閲覧期限,limitPeriod|閲覧回数,limitCount|受信者ビュアーID,receiverID",
                                        "value_jp"=>"",
                                        "default_jp"=>"%userName%(%hostName%)さんがSECUDRIVE File Centralizationファイルのエクスポートを申請しました。\\n\\n申請時間:\\n%requestTime%\\n\\nエクスポート内容:\\n%content%\\n\\n受信者情報:\\n名前:%receiverName%\\nメール:%receiverMail%\\n会社:%company%\\n閲覧期限:%limitPeriod%까지\\n閲覧回数:%limitCount%回 (0なら制限なし)\\n受信者ビュアーID:%receiverID%\\n\\nエクスポート事由:\\n%reason%\\n\\n上記のエクスポートを承認するには、下記のリンクをクリックしてください:\\n<a href=\"%linkAccept%\">承認</a>\\n\\n上記のエクスポートを拒否するには、下記のリンクをクリックしてください:\\n<a href=\"%linkDeny%\">拒否</a>",
                                ),
);

class MailSend
{
        var $lang = 0;
        function __construct()
        {

        }

        function SetLanguage($w_lang_index)
        {
            $this->lang = $w_lang_index;
        }

        function Send($message)
        {
            $w_data_ctrl = new DataCtrl;
            $w_smtp_url = $w_data_ctrl->GetSetting("SmtpUrl");
            $w_smtp_password = $w_data_ctrl->GetSetting("SmtpPassword");
            $w_smtp_id = $w_data_ctrl->GetSetting("SmtpId");
            $w_smtp_port = $w_data_ctrl->GetSetting("SmtpPort");
            $w_smtp_security = $w_data_ctrl->GetSetting("SmtpSecurity");
            $w_smtp_auth = $w_data_ctrl->GetSetting("SmtpAuth");

            return $this->SendTo($message, $w_smtp_url, $w_smtp_port, $w_smtp_id, $w_smtp_password, $w_smtp_security, $w_smtp_auth);
        }

        function SendTo($message, $smtp_url, $smtp_port, $smtp_id, $smtp_password, $w_smtp_security, $w_smtp_auth)
        {
            $mail = $message;
            $mail->isSMTP();
            //$mail->SMTPDebug  = 2;
            $mail->Host = $smtp_url;
            $mail->SMTPAuth = $w_smtp_auth;
            $mail->Username = $smtp_id;
            $mail->Password = $smtp_password;

            if ($w_smtp_security == 1)
                $mail->SMTPSecure = 'tls';
            else if ($w_smtp_security == 2)
                $mail->SMTPSecure = 'ssl';
            else
                $mail->SMTPSecure = 'none';

            $mail->Port = $smtp_port;
            $mail->CharSet = "UTF-8";
            $mail->isHTML(true);

            //return $mail->Send();
            $w_bRet = $mail->Send();
            if(!$w_bRet)
            {
                FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Mail Send Failed : ".$mail->ErrorInfo);
            }
            return $w_bRet;
        }

        function AdminMailTest($admin_name, $admin_mail, $smtp_url, $smtp_port, $smpt_id, $smtp_password, $w_smtp_security, $w_smtp_auth)
        {
            $mail = new PHPMailer;
            $mail->AddAddress($admin_mail, $admin_name);
            $mail->SetFrom($admin_mail);

            $dic = array(
                    "name" => $admin_name,
                    "email" => $admin_mail,
            );

            $mail->Subject = GetTitle("StrMailAdminMail", $dic, $this->lang);
            $mail->Body = GetBody("StrMailAdminMail", $dic, $this->lang);

            return $this->SendTo($mail, $smtp_url, $smtp_port, $smpt_id, $smtp_password, $w_smtp_security, $w_smtp_auth);
        }

        function FCApproveLink($userName, $hostName, $content, $strPeriod, $reason, $approver, $reg_time, $link_accept, $link_deny)
        {
            $w_data_ctrl = new DataCtrl;

            $mail = new PHPMailer;
            $mail_address = $mail->parseAddresses($approver);
            if (count($mail_address) == 0) {
                $mail->AddAddress($approver);
            }
            else {
                $mail->AddAddress($mail_address[0][address], $mail_address[0][name]);
            }
            $mail->SetFrom($w_data_ctrl->GetSetting("AdminEmail"), $w_data_ctrl->GetSetting("AdminName"));


            $dic = array(
                "linkAccept" => $link_accept,
                "linkDeny" => $link_deny,
                "userName" => $userName,
                "hostName" => $hostName,
                "content" => $content,
                "period" => $strPeriod,
                "reason" => $reason,
                "requestTime" => $reg_time,
            );

            $mail->Subject = GetTitle("StrMailFCRequest", $dic, $this->lang);
            $mail->Body = GetBody("StrMailFCRequest", $dic, $this->lang);

            return $this->Send($mail);
        }

        function ExportApproveLink($userName, $hostName, $content, $reason, $approver, $reg_time, $link_accept, $link_deny, $export_mode)
        {
            $w_data_ctrl = new DataCtrl;

            $mail = new PHPMailer;
            $mail_address = $mail->parseAddresses($approver);
            if (count($mail_address) == 0) {
                $mail->AddAddress($approver);
            }
            else {
                $mail->AddAddress($mail_address[0][address], $mail_address[0][name]);
            }
            $mail->SetFrom($w_data_ctrl->GetSetting("AdminEmail"), $w_data_ctrl->GetSetting("AdminName"));


            $dic = array(
                "linkAccept" => $link_accept,
                "linkDeny" => $link_deny,
                "userName" => $userName,
                "hostName" => $hostName,
                "content" => $content,
                "reason" => $reason,
                "requestTime" => $reg_time,
                "exportMode" => GetExportModeStr($export_mode, $this->lang),
            );

            $mail->Subject = GetTitle("StrMailExportRequest", $dic, $this->lang);
            $mail->Body = GetBody("StrMailExportRequest", $dic, $this->lang);

            return $this->Send($mail);
        }

    function ExportPDFApproveLink($userName, $hostName, $content, $reason, $approver, $reg_time, $link_accept, $link_deny, $export_mode, $receiver_name, $receiver_mail, $company, $limit_period, $limit_count, $receiver_id)
    {
        $w_data_ctrl = new DataCtrl;

        $mail = new PHPMailer;
        $mail_address = $mail->parseAddresses($approver);
        if (count($mail_address) == 0) {
            $mail->AddAddress($approver);
        }
        else {
            $mail->AddAddress($mail_address[0][address], $mail_address[0][name]);
        }
        $mail->SetFrom($w_data_ctrl->GetSetting("AdminEmail"), $w_data_ctrl->GetSetting("AdminName"));


        $dic = array(
            "linkAccept" => $link_accept,
            "linkDeny" => $link_deny,
            "userName" => $userName,
            "hostName" => $hostName,
            "content" => $content,
            "reason" => $reason,
            "requestTime" => $reg_time,
            "exportMode" => GetExportModeStr($export_mode, $this->lang),
            "receiverName" => $receiver_name,
            "receiverMail" => $receiver_mail,
            "company" => $company,
            "limitPeriod" => $limit_period,
            "limitCount" => $limit_count,
            "receiverID" => $receiver_id,
        );

        $mail->Subject = GetTitle("StrMailExportPDFRequest", $dic, $this->lang);
        $mail->Body = GetBody("StrMailExportPDFRequest", $dic, $this->lang);

        return $this->Send($mail);
    }
}
