<?php

    require_once("DataCtrl.php");
    require_once("AppParam.php");
    require_once("MailSend.php");
    require_once("StringRes.php");
    require_once("CodeCtrl.php");
    require_once("log.php");

    function curPageURL() {
        $pageURL = 'http';
        if (isset($_SERVER["HTTPS"]) == true && $_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
        $pageURL .= "://";
        if ($_SERVER["SERVER_PORT"] != "80") {
            $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["SCRIPT_NAME"];
        } else {
            $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["SCRIPT_NAME"];
        }
        return $pageURL;
    }

    function GetClientIP() {
        $ip_address = "";
        if (isset($_SERVER['HTTP_CLIENT_IP']) == true)
            $ip_address = $_SERVER['HTTP_CLIENT_IP'];
        else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']) == true)
            $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_X_FORWARDED']) == true)
            $ip_address = $_SERVER['HTTP_X_FORWARDED'];
        else if(isset($_SERVER['HTTP_FORWARDED_FOR']) == true)
            $ip_address = $_SERVER['HTTP_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_FORWARDED']) == true)
            $ip_address = $_SERVER['HTTP_FORWARDED'];
        else if(isset($_SERVER['REMOTE_ADDR']) == true)
            $ip_address = $_SERVER['REMOTE_ADDR'];
        else
            $ip_address = 'UNKNOWN';

        return $ip_address;
    }

    function readfile_chunked($filename,$retbytes=true) {
        $chunksize = 1*(1024*1024); // how many bytes per chunk
        $buffer = '';
        $cnt =0;
        // $handle = fopen($filename, 'rb');
        $handle = fopen($filename, 'rb');
        if ($handle === false) {
            return false;
        }
        while (!feof($handle)) {
            $buffer = fread($handle, $chunksize);
            echo $buffer;
            ob_flush();
            flush();
            if ($retbytes) {
                $cnt += strlen($buffer);
            }
        }
        $status = fclose($handle);
        if ($retbytes && $status) {
            return $cnt; // return num. bytes delivered like readfile() does.
        }
        return $status;

    }

    function GetLink($req, $ans)
    {
        $url = curPageURL();
        $url .= "?request=" . $req . "&ans=" . $ans;
        return $url;
    }

    function Login()
    {
        $w_app_param = new AppParam;
        $w_data_ctrl = new DataCtrl();
        $w_data_ctrl->UpgradeDB();

        $w_app_param->SetResult(Result::Success);

        echo $w_app_param->Get();
    }

    function SendTempPolicyToApprover()
    {
        try {
            do {
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Start SendTempPolicyToApprover()");
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;
                $w_mail_send = new MailSend;

                $w_uuid = $_POST["uuid"];
                $w_userName = $_POST["username"];
                $w_hostName = $_POST["hostname"];
                $w_content = $_POST["content"];
                $w_period = $_POST["period"];
                $w_reason = $_POST["reason"];
                $w_approver = $_POST["approver"];
                $w_lang_id = $_POST["lang_id"];
                $w_req_time = date("Y-m-d H:i:s");
                $w_strPeriod = $w_period;//date("Y-m-d", $w_period);

                $w_data_ctrl->AddPolicyStatus($w_uuid, FCStatus::StatusApporveWait);

                $w_approve_link = GetLink("dopolaprv", FCRequestLinkCode($w_uuid, true, $w_lang_id, 0));
                $w_deny_link = GetLink("dopolaprv", FCRequestLinkCode($w_uuid, false, $w_lang_id, 0));

                $w_mail_send->SetLanguage($w_lang_id);

                if ($w_mail_send->FCApproveLink($w_userName, $w_hostName, $w_content, $w_strPeriod, $w_reason, $w_approver, $w_req_time, $w_approve_link, $w_deny_link) == false)
                {
                    FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Failed SendTempPolicyToApprover() : FCApproveLink mail send failed.");
                    $w_app_param->SetResult(Result::FailMail);
                    break;
                }
                $w_app_param->SetResult(Result::Success);
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Success SendTempPolicyToApprover()");
            }while (false);
            echo  $w_app_param->Get();
        }
        catch (Exception $exception)
        {

        }
//        $w_mail_send->SetLanguage(0);
    }

    function CancelTempPolicy()
    {
        try {
            do {
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Start CancelTempPolicy()");
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_uuid = $_POST["uuid"];

                $w_data_ctrl->SetPolicyStatus($w_uuid, FCStatus::StatusCancel);

                $w_app_param->SetResult(Result::Success);
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Success CancelTempPolicy()");
            }while (false);
            echo  $w_app_param->Get();
        }
        catch (Exception $exception)
        {

        }
        //        $w_mail_send->SetLanguage(0);
    }

    function GetTempPolicyApproveStatus()
    {
        $w_data_ctrl = new DataCtrl;
        $w_app_param = new AppParam;

        $w_uuid = $_POST["uuid"];
        $w_status = $w_data_ctrl->GetPolicyStatus($w_uuid);

        $w_app_param->Set("status", $w_status);
        $w_app_param->SetResult(Result::Success);

        echo  $w_app_param->Get();
    }

    function DoTempPolicyApprove()
    {
        try {
            do {
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_ans = $_GET["ans"];

                $w_uuid = "";
                $w_is_approved = false;
                $w_lang_index = 0;
                $w_export_mode = 0;
                $w_admin_lang = $w_data_ctrl->GetSetting("AdminLang");

                FCRequestLinkDecode($w_ans, $w_uuid, $w_is_approved, $w_lang_index, $w_export_mode);

                $w_status = $w_data_ctrl->GetPolicyStatus($w_uuid);
                if ($w_status == FCStatus::StatusCancel)
                {
                    $w_app_param->SetString(GetString("StrPageUserAlreadCanceled", $w_admin_lang));
                    break;
                }
                else if ($w_status != FCStatus::StatusApporveWait)
                {
                    $w_app_param->SetString(GetString("StrPageUserAlreadProcessed", $w_admin_lang));
                    break;
                }

                if ($w_is_approved)
                {
                    $w_data_ctrl->SetPolicyStatus($w_uuid, FCStatus::StatusApproved);
                    $w_app_param->SetString(GetString("StrPageFCPolicyApproved", $w_admin_lang));
                }
                else
                {
                    $w_data_ctrl->SetPolicyStatus($w_uuid, FCStatus::StatusDeny);
                    $w_app_param->SetString(GetString("StrPageFCPolicyDeny", $w_admin_lang));
                }

            } while (false);

            echo $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function SendExportToApprover()
    {
        try {
            do {
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Start SendExportToApprover()");
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;
                $w_mail_send = new MailSend;

                $w_uuid = $_POST["uuid"];
                $w_userName = $_POST["username"];
                $w_hostName = $_POST["hostname"];
                $w_content = $_POST["content"];
                $w_reason = $_POST["reason"];
                $w_approver = $_POST["approver"];
                $w_lang_id = $_POST["lang_id"];
                $w_req_time = date("Y-m-d H:i:s");
                $w_export_mode = $_POST["export_mode"];

                $w_data_ctrl->AddExportStatus($w_uuid, FCStatus::StatusApporveWait);

                $w_approve_link = GetLink("doexpaprv", FCRequestLinkCode($w_uuid, true, $w_lang_id, $w_export_mode));
                $w_deny_link = GetLink("doexpaprv", FCRequestLinkCode($w_uuid, false, $w_lang_id, $w_export_mode));

                $w_mail_send->SetLanguage($w_lang_id);

                if ($w_export_mode == ExportMode::ExportModePDF)
                {
                    $w_pdf_uuids = $_POST["pdf_uuids"];
                    $w_pdf_count = $_POST["pdf_count"];
                    $w_pdf_period_value = $_POST["pdf_period"];
                    $w_pdf_period = date("Y-m-d H:i:s", $w_pdf_period_value);
                    $w_receiver_name = $_POST["receiver_name"];
                    $w_receiver_mail = $_POST["receiver_mail"];
                    $w_receiver_id = $_POST["receiver_id"];
                    $w_receiver_company = $_POST["company"];
                    $w_data_ctrl->SecurePDFFilesADD($w_uuid, $w_pdf_uuids, $w_receiver_name, $w_receiver_mail, $w_receiver_company, $w_receiver_id, $w_pdf_count, $w_pdf_period, $w_content);

                    if ($w_mail_send->ExportPDFApproveLink($w_userName, $w_hostName, $w_content, $w_reason, $w_approver, $w_req_time, $w_approve_link, $w_deny_link, $w_export_mode, $w_receiver_name, $w_receiver_mail, $w_receiver_company, $w_pdf_period, $w_pdf_count, $w_receiver_id) == false)
                    {
                        FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Failed SendExportToApprover() : ExportPDFApproveLink mail send failed.");
                        $w_app_param->SetResult(Result::FailMail);
                        break;
                    }
                }
                else
                {
                    if ($w_mail_send->ExportApproveLink($w_userName, $w_hostName, $w_content, $w_reason, $w_approver, $w_req_time, $w_approve_link, $w_deny_link, $w_export_mode) == false)
                    {
                        FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Failed SendExportToApprover() : ExportApproveLink mail send failed.");
                        $w_app_param->SetResult(Result::FailMail);
                        break;
                    }
                }

                $w_app_param->SetResult(Result::Success);
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Success SendExportToApprover()");
            }while (false);
            echo  $w_app_param->Get();
        }
        catch (Exception $exception)
        {

        }
    //        $w_mail_send->SetLanguage(0);
    }

    function CancelExport()
    {
        try {
            do {
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Start CancelExport()");
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_uuid = $_POST["uuid"];

                $w_data_ctrl->SetExportStatus($w_uuid, FCStatus::StatusCancel);

                $w_app_param->SetResult(Result::Success);
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Success CancelExport()");
            }while (false);
            echo  $w_app_param->Get();
        }
        catch (Exception $exception)
        {

        }
        //        $w_mail_send->SetLanguage(0);
    }

    function GetExportApproveStatus()
    {
        $w_data_ctrl = new DataCtrl;
        $w_app_param = new AppParam;

        $w_uuid = $_POST["uuid"];
        $w_status = $w_data_ctrl->GetExportStatus($w_uuid);

        $w_app_param->Set("status", $w_status);
        $w_app_param->SetResult(Result::Success);

        echo  $w_app_param->Get();
    }

    function DoExportApprove()
    {
        try {
            do {
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_ans = $_GET["ans"];

                $w_uuid = "";
                $w_is_approved = false;
                $w_lang_index = 0;
                $w_export_mode = ExportMode::ExportModeACP;
                $w_admin_lang = $w_data_ctrl->GetSetting("AdminLang");

                FCRequestLinkDecode($w_ans, $w_uuid, $w_is_approved, $w_lang_index, $w_export_mode);

                $w_status = $w_data_ctrl->GetExportStatus($w_uuid);
                if ($w_status == FCStatus::StatusCancel)
                {
                    $w_app_param->SetString(GetString("StrPageUserAlreadCanceled", $w_admin_lang));
                    break;
                }
                else if ($w_status != FCStatus::StatusApporveWait)
                {
                    $w_app_param->SetString(GetString("StrPageUserAlreadProcessed", $w_admin_lang));
                    break;
                }

                if ($w_is_approved)
                {
                    $w_data_ctrl->SetExportStatus($w_uuid, FCStatus::StatusApproved);
                    if ($w_export_mode == ExportMode::ExportModePDF)
                        $w_data_ctrl->SetSecuPDFStatus($w_uuid, FCStatus::StatusApproved);

                    $w_app_param->SetString(GetString("StrPageExportAcceptSuccess", $w_admin_lang));
                }
                else
                {
                    $w_data_ctrl->SetExportStatus($w_uuid, FCStatus::StatusDeny);
                    if ($w_export_mode == ExportMode::ExportModePDF)
                        $w_data_ctrl->SetSecuPDFStatus($w_uuid, FCStatus::StatusDeny);

                    $w_app_param->SetString(GetString("StrPageExportDeny", $w_admin_lang));
                }

            } while (false);

            echo $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function SetSMTP()
    {
        try {
            do {
                    FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Start changeEmail() ");

                    $w_data_ctrl = new DataCtrl;
                    $w_app_param = new AppParam;
                    $w_mail = new MailSend;

                    $w_admin_name = $_POST["Name"];
                    $w_admin_mail = $_POST["Mail"];
                    $w_smtp_url = $_POST["SmtpUrl"];
                    $w_smtp_id = $_POST["SmtpId"];
                    $w_smtp_password = $_POST["SmtpPassword"];
                    $w_smtp_port = $_POST["SmtpPort"];
                    $w_smtp_security = $_POST["SmtpSecurity"];
                    $w_smtp_auth = $_POST["SmtpAuth"];
                    $w_langIdx = $_POST["LangIndex"];

                    $w_mail->SetLanguage($w_langIdx);

                    if ($w_mail->AdminMailTest($w_admin_name, $w_admin_mail, $w_smtp_url, $w_smtp_port, $w_smtp_id, $w_smtp_password, $w_smtp_security, $w_smtp_auth) == false)
                    {
                        FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Failed changeEmail() :  AdminMail send failed.");

                        $w_app_param->SetResult(Result::FailMail);
                        break;
                    }

                    if ($w_data_ctrl->SetSetting("AdminName", $w_admin_name) == false ||
                        $w_data_ctrl->SetSetting("AdminEmail", $w_admin_mail) == false ||
                        $w_data_ctrl->SetSetting("SmtpUrl", $w_smtp_url) == false ||
                        $w_data_ctrl->SetSetting("SmtpId", $w_smtp_id) == false ||
                        $w_data_ctrl->SetSetting("SmtpPort", $w_smtp_port) == false ||
                        $w_data_ctrl->SetSetting("SmtpSecurity", $w_smtp_security) == false ||
                        $w_data_ctrl->SetSetting("SmtpAuth", $w_smtp_auth) == false ||
                        $w_data_ctrl->SetSetting("SmtpPassword", $w_smtp_password) == false ||
                        $w_data_ctrl->SetSetting("AdminLang", $w_langIdx) == false)
                    {
                        FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Failed changeEmail() : change mail failed to db.");
                        $w_app_param->SetResult(Result::Fail);
                        break;
                    }

                    $w_app_param->SetResult(Result::Success);
                    FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Success changeEmail()");

            } while (false);

            echo $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function GetSMTP()
    {
        try {
            do {
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_email_name = $w_data_ctrl->GetSetting("AdminName");
                $w_mail_addr = $w_data_ctrl->GetSetting("AdminEmail");
                $w_smtp_url = $w_data_ctrl->GetSetting("SmtpUrl");
                $w_smtp_id = $w_data_ctrl->GetSetting("SmtpId");
                $w_smtp_password = $w_data_ctrl->GetSetting("SmtpPassword");
                $w_smtp_port = $w_data_ctrl->GetSetting("SmtpPort");
                $w_smtp_security = $w_data_ctrl->GetSetting("SmtpSecurity");
                $w_smtp_auth = $w_data_ctrl->GetSetting("SmtpAuth");

                $w_app_param->Set("Name", $w_email_name);
                $w_app_param->Set("Mail", $w_mail_addr);
                $w_app_param->Set("SmtpUrl", $w_smtp_url);
                $w_app_param->Set("SmtpId", $w_smtp_id);
                $w_app_param->Set("SmtpPassword", $w_smtp_password);
                $w_app_param->Set("SmtpPort", $w_smtp_port);
                $w_app_param->Set("SmtpSecurity", $w_smtp_security);
                $w_app_param->Set("SmtpAuth", $w_smtp_auth);

                $w_app_param->SetResult(Result::Success);

            } while (false);

            echo $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function TestSMTP()
    {
        try {
            do {
                $w_app_param = new AppParam;

                $w_email_name = $_POST["Name"];
                $w_mail_addr = $_POST["Mail"];
                $w_smtp_url = $_POST["SmtpUrl"];
                $w_smtp_id = $_POST["SmtpId"];
                $w_smtp_password = $_POST["SmtpPassword"];
                $w_smtp_port = $_POST["SmtpPort"];
                $w_smtp_security = $_POST["SmtpSecurity"];
                $w_smtp_auth = $_POST["SmtpAuth"];
                $w_lang = $_POST["LangIndex"];

                $w_mail = new MailSend();
                $w_mail->SetLanguage($w_lang);

                if ($w_mail->AdminMailTest($w_email_name, $w_mail_addr, $w_smtp_url, $w_smtp_port, $w_smtp_id, $w_smtp_password, $w_smtp_security, $w_smtp_auth) == false)
                {
                    FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Failed mailtest() :  AdminMail send failed.");
                    $w_app_param->SetResult(Result::FailMail);
                    break;
                }

                $w_app_param->SetResult(Result::Success);

            } while (false);

            echo $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function CheckSecurePDF()
    {
        try {
            do {
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Start Check Secure PDF");
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_doc_id         = $_POST["docid"];
                $w_view_id        = $_POST["viewer_id"];
                $w_pc_name        = $_POST["pcname"];
                $w_file_size      = $_POST["size"];
                $w_file_name      = $_POST["name"];

                $w_global_ip       = GetClientIP();
                $w_arr_ip = explode(",", $w_global_ip);

                $w_data = $w_data_ctrl->GetApprovedSecuPDF($w_doc_id);

                if (empty($w_data))
                {
                    $w_app_param->SetResult(Result::Fail);
                    break;
                }

                $w_cur_view_count = $w_data[0]->view_count;
                $w_limit_count = $w_data[0]->limit_count;
                $w_limit_date = $w_data[0]->limit_date;
                // $w_filename = $w_data[0]->filename;
                $w_receiver_name = $w_data[0]->receiver_name;
                $w_receiver_mail = $w_data[0]->receiver_mail;

                if ($w_limit_count > 0 && $w_cur_view_count >= $w_limit_count)
                {
                    $w_data_ctrl->AddSecuPDFLog(LogAction::LogSecuPDFCountLimit, $w_view_id, $w_file_name, $w_receiver_name, $w_receiver_mail,  $w_arr_ip[0], $w_pc_name, $w_file_size);
                    $w_app_param->SetResult(Result::FailLicenseCount);
                    break;
                }

                $w_cur_date = new DateTime("NOW");
                $w_limit_time = DateTime::createFromFormat("Y-m-d H:i:s", $w_limit_date);
                if ($w_limit_date > 0 && $w_cur_date >= $w_limit_time)
                {
                    $w_data_ctrl->AddSecuPDFLog(LogAction::LogSecuPDFDateLimit, $w_view_id, $w_file_name, $w_receiver_name, $w_receiver_mail,  $w_arr_ip[0], $w_pc_name, $w_file_size);
                    $w_app_param->SetResult(Result::FailLicenseDate);
                    break;
                }

                $w_data_ctrl->AddSecuPDFLog(LogAction::LogSecuPDFOpen, $w_view_id, $w_file_name, $w_receiver_name, $w_receiver_mail,  $w_arr_ip[0], $w_pc_name, $w_file_size);
                $w_cur_view_count++;
                $w_data_ctrl->SetSecuPDFViewCount($w_doc_id, $w_cur_view_count);
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Success Check Secure PDF");
                $w_app_param->SetResult(Result::Success);
            } while (false);

            echo $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function AddSecuPDFLog()
    {
        try {
            do {
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Start Set Secure PDF Log");
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_doc_id         = $_POST["docid"];
                $w_view_id        = $_POST["viewer_id"];
                $w_pc_name         = $_POST["pcname"];
                $log_type         = $_POST["log_type"];

                $w_global_ip       = GetClientIP();
                $w_arr_ip = explode(",", $w_global_ip);

                $w_data = $w_data_ctrl->GetApprovedSecuPDF($w_doc_id);

                if (empty($w_data))
                {
                    $w_app_param->SetResult(Result::Fail);
                    break;
                }

                if ($log_type == 100)
                {
                    $w_data_ctrl->AddSecuPDFLog(LogAction::LogSecuPDFBlockViewerID, $w_view_id, $w_data[0]->filename, $w_data[0]->receiver_name, $w_data[0]->receiver_mail,  $w_arr_ip[0], $w_pc_name, $w_data[0]->filesize);
                }

                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Success Set Secure PDF Log");
                $w_app_param->SetResult(Result::Success);
            } while (false);

            echo $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function GetLog()
    {
        try {
            do {
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Start Get Log");
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_data = $w_data_ctrl->GetLog();
                if (!empty($w_data)) {
                    $w_data_ctrl->DeleteLog();
                }

                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Success Set Secure PDF Log");
                $w_app_param->SetArray("log", $w_data);
                $w_app_param->SetResult(Result::Success);
            } while (false);

            echo $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function UploadData()
    {
        try {
            do {
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Start Add Export");
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_upload_uuid = $_POST["upload_uuid"];
                $w_uuid = $_POST["uuid"];
                $w_upload_file = $_POST["upload_file"];
                $w_upload_file_size = $_POST["upload_file_size"];
                $w_original_file_size = $_POST["org_file_size"];
                $w_export_file = $_POST["export_file"];
                $w_lang_id = $_POST["lang_id"];
                $w_is_approved = $_POST["is_approved"];

                if ($w_data_ctrl->AddUpload($w_upload_uuid, $w_uuid, UploadStatus::StatusUpload, GetUploadPath($w_upload_file), $w_upload_file_size, $w_export_file, $w_is_approved, $w_original_file_size) == false)
                {
                    FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Failed Add Export.");
                    $w_app_param->SetResult(Result::Fail);
                    break;
                }

                $w_download_link = GetLink("download", FCDownloadLinkCode($w_upload_uuid, $w_lang_id));
                $w_limit_day = $w_data_ctrl->GetSetting("Limit Day");
                $w_limit_count = $w_data_ctrl->GetSetting("Limit Count");
                $w_limit_date = new DateTime('NOW');
                $w_limit_date->add(new DateInterval("P" . $w_limit_day . "D"));

                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Success Add Upload Data");

                $w_app_param->Set("download_link", $w_download_link);
                $w_app_param->Set("limit_count", $w_limit_count);
                $w_app_param->Set("limit_date", $w_limit_date->getTimestamp());
                $w_app_param->SetResult(Result::Success);
            } while (false);

            echo $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function Upload()
    {
        try {
            do {
                $w_app_param = new AppParam;

                $w_upload_name = $_POST["uploadName"];
                $w_offset = $_POST["offset"];

                // read temp file
                $w_temp_file_name = $_FILES["file"]['tmp_name'];
                $w_temp_file = fopen($w_temp_file_name, "rb+");
                if ($w_temp_file === false)
                {
                    FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Failed Upload() : temp file open failed.");
                    $w_app_param->SetResult(Result::Fail);
                    break;
                }
                $w_temp_file_size = filesize($w_temp_file_name);
                $content = fread($w_temp_file, $w_temp_file_size);
                fclose($w_temp_file);

                // write file.
                $w_upload_path = GetUploadPath($w_upload_name);
                if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
                    $w_upload_path = iconv("UTF-8", "cp949", $w_upload_path);

                if (file_exists(dirname($w_upload_path)) == false)
                    mkdir(dirname($w_upload_path), 0777, true);

                $w_file = fopen($w_upload_path, "c");
                if ($w_file === false)
                {
                    FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Failed Upload() : upload file open failed.");
                    $w_app_param->SetResult(Result::Fail);
                    break;
                }

                fseek($w_file, $w_offset);
                fwrite($w_file, $content, $w_temp_file_size);
                fclose($w_file);


                $w_app_param->SetResult(Result::Success);

            } while (false);

            echo  $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function IsUploadOK()
    {
        try {
            do {
                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Start Is Upload OK");
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_uuid = $_POST["uuid"];
                $w_upload_file_size = $_POST["org_file_size"];

                $w_max_count = $w_data_ctrl->GetSetting("Daily Max Count");
                $w_total_size = $w_data_ctrl->GetSetting("Daily Total Size");

                $w_count = $w_data_ctrl->GetUploadCount($w_uuid);
                $w_size = $w_data_ctrl->GetUploadSize($w_uuid);

                if ($w_count + 1 > $w_max_count)
                {
                    FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Upload denied because of count.");
                    $w_app_param->SetResult(Result::FailUploadCount);
                    break;
                }

                if (($w_size + $w_upload_file_size) / 1024.0 / 1024.0 > $w_total_size)
                {
                    FT_DEBUG_LOG(basename(__FILE__), DBG_ERROR, "Upload denied because of size.");
                    $w_app_param->SetResult(Result::FailUploadSize);
                    break;
                }

                FT_DEBUG_LOG(basename(__FILE__), DBG_TRACE, "Success Is Upload OK");

                $w_app_param->SetResult(Result::Success);
            } while (false);

            echo  $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    function Download()
    {
        try {
            do {
                $w_data_ctrl = new DataCtrl;
                $w_app_param = new AppParam;

                $w_ans = $_GET["ans"];
                $w_global_ip = GetClientIP();
                $w_arr_ip = explode(",", $w_global_ip);

                $w_upload_uuid = "";
                $w_lang_index = 0;

                FCDownloadLinkDecode($w_ans, $w_upload_uuid, $w_lang_index);

                $w_data = $w_data_ctrl->GetUpload($w_upload_uuid);
                if (empty($w_data))
                {
                    $w_app_param->SetString(GetString("StrInvalidRequest", $w_lang_index));
                    echo $w_app_param->Get();
                    break;
                }

                if (empty($w_data[0]->upload_file))
                {
                    $w_app_param->SetString(GetString("StrInvalidRequest", $w_lang_index));
                    echo $w_app_param->Get();
                    break;
                }

                if ($w_data[0]->limit_count <= $w_data[0]->download_count)
                {
                    $w_data_ctrl->AddUploadLog(LogAction::LogUploadCountLimit, $w_data[0]->upload_file, $w_data[0]->upload_file_size, $w_data[0]->export_file, $w_arr_ip[0]);
                    $w_data_ctrl->SetUploadStatus($w_upload_uuid, UploadStatus::StatusLimitCount);
                    $w_app_param->SetString(GetString("StrPageExportDenyCount", $w_lang_index));
                    echo $w_app_param->Get();
                    break;
                }

                $w_cur_time = new DateTime("NOW");
                $w_limit_time = new DateTime($w_data[0]->limit_time);
                if ($w_limit_time <= $w_cur_time)
                {
                    $w_data_ctrl->AddUploadLog(LogAction::LogUploadDateLimit, $w_data[0]->upload_file, $w_data[0]->upload_file_size, $w_data[0]->export_file, $w_arr_ip[0]);
                    $w_data_ctrl->SetUploadStatus($w_upload_uuid, UploadStatus::StatusLimitDate);
                    $w_app_param->SetString(GetString("StrPageExportDenyDate", $w_lang_index));
                    echo $w_app_param->Get();
                    break;
                }

                // increase download count
                $w_data_ctrl->SetDownloadCount($w_upload_uuid, $w_data[0]->download_count + 1);

                $w_upload_path = $w_data[0]->upload_file;
                $w_download_path = GetBaseName($w_upload_path);
                if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
                    $w_upload_path = iconv("UTF-8", "cp949", $w_upload_path);

                // File Download
                header("content-type: application/octet-stream");
                header("content-length: ".filesize($w_upload_path));
                header("content-disposition: attachment; filename=\"".$w_download_path."\"");
                header("content-transfer-encoding: binary");
                readfile_chunked($w_upload_path);

                $w_data_ctrl->AddUploadLog(LogAction::LogUploadDownload, $w_upload_path, $w_data[0]->upload_file_size, $w_data[0]->export_file, $w_arr_ip[0]);

            } while (false);

            // echo $w_app_param->Get();
        }
        catch (Exception $exception)
        {
        }
    }

    try {
        do {
            if ($_POST != null)
                $w_request = $_POST["request"];
            else
                $w_request = $_GET["request"];

            if ($w_request == "setpol")
            {
                SendTempPolicyToApprover();
            }
            else if ($w_request == "getpol")
            {
                GetTempPolicyApproveStatus();
            }
            else if ($w_request == "dopolaprv")
            {
                DoTempPolicyApprove();
            }
            else if ($w_request == "cancelpol")
            {
                CancelTempPolicy();
            }
            else if ($w_request == "setexp")
            {
                SendExportToApprover();
            }
            else if ($w_request == "getexp")
            {
                GetExportApproveStatus();
            }
            else if ($w_request == "doexpaprv")
            {
                DoExportApprove();
            }
            else if ($w_request == "cancelexp")
            {
                CancelExport();
            }
            else if ($w_request == "setsmtp")
            {
                SetSMTP();
            }
            else if ($w_request == "getsmtp")
            {
                GetSMTP();
            }
            else if ($w_request == "testsmtp")
            {
                TestSMTP();
            }
            else if ($w_request == "login")
            {
                Login();
            }
            else if ($w_request == "chksecupdf")
            {
                CheckSecurePDF();
            }
            else if ($w_request == "secupdflog")
            {
                AddSecuPDFLog();
            }
            else if ($w_request == "getlog")
            {
                GetLog();
            }
            else if ($w_request == "upload")
            {
                Upload();
            }
            else if ($w_request == "uploaddata")
            {
                UploadData();
            }
            else if ($w_request == "isuploadok")
            {
                IsUploadOK();
            }
            else if ($w_request == "download")
            {
                Download();
            }

        } while (false);
    }
    catch (Exception $exception)
    {
        echo $exception->getMessage();
    }
